
ServerEvents.recipes(e => {

    // 结晶法杖
    e.shaped(
        Item.of("l2complements:diffusion_wand"),
        [
            " FM",
            " CF",
            "C  "
        ],
        {
            C: "minecraft:stick",          // 木棍
            F: "minecraft:diamond",        // 钻石
            M: "l2complements:storm_core"  // 风暴核心
        }
    ).id("kubejs:l2complements/diffusion_wand").stage("ON");

    // 亚伯拉大
    e.shaped(
        Item.of("l2hostility:abrahadabra"),
        [
            "AIA",
            "EOE",
            "BIC"
        ],
        {
            A: "l2hostility:ragnarok",         // 诸神黄昏符文
            B: "l2hostility:repelling",        // 排斥符文
            C: "l2hostility:pulling",          // 拉扯符文
            E: "l2complements:eternium_ingot", // 永恒锭
            I: "l2hostility:miracle_ingot",    // 奇迹锭
            O: "l2hostility:ring_of_reflection"// 反射之戒
        }
    ).id("kubejs:l2hostility/abrahadabra").stage("ON");

    // 深渊之刺
    e.shaped(
        Item.of("l2hostility:abyssal_thorn"),
        [
            "AIA",
            "IEI",
            "XIX"
        ],
        {
            A: "l2complements:guardian_eye",     // 守卫者之眼
            E: "l2complements:eternium_ingot",   // 永恒锭
            I: "l2hostility:miracle_ingot",      // 奇迹锭
            X: "l2complements:blackstone_core"   // 黑石核心
        }
    ).id("kubejs:l2hostility/abyssal_thorn").stage("ON");

    // 恶意指南
    if (Platform.isLoaded("patchouli")) {
        e.custom({
            type: "patchouli:shapeless_book_recipe",
            book: "l2hostility:hostility_guide",
            ingredients: [
                { item: "minecraft:book" },         // 书
                { item: "minecraft:rotten_flesh" }, // 腐肉
                { item: "minecraft:bone" }           // 骨头
            ]
        }).id("kubejs:l2hostility/hostility_guide_book").stage("ON");
    }

    // 全知之书
    e.shapeless(
        Item.of("l2hostility:book_of_omniscience"),
        [
            "l2hostility:book_of_reprint", // 重印之书
            "l2hostility:reprint",         // 重印符文
            "l2hostility:split",           // 分裂符文
            "minecraft:nether_star"        // 下界之星
        ]
    ).id("kubejs:l2hostility/book_of_omniscience").stage("ON");

    // 阿尔法雪人 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:alpha_yeti_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:regenerate",         // 再生符文
                "2": "l2hostility:cursed",             // 诅咒符文
                A: "twilightforest:alpha_yeti_fur",  // 阿尔法雪人毛皮
                I: "l2hostility:chaos_ingot",        // 混沌锭
                T: "twilightforest:alpha_yeti_trophy"// 阿尔法雪人战利品
            }
        ).id("kubejs:l2hostility/alpha_yeti_boss_spawner").stage("ON");
    }

    // 增效药水
    e.shapeless(
        Item.of("l2hostility:booster_potion"),
        [
            "l2hostility:witch_droplet",    // 女巫飞沫
            "l2hostility:bottle_of_sanity", // 理智之瓶
            "l2complements:life_essence"    // 生命精华
        ]
    ).id("kubejs:l2hostility/booster_potion").stage("ON");

    // 理智之瓶  * 3
    e.shapeless(
        Item.of("l2hostility:bottle_of_sanity", 3),
        [
            "l2hostility:hostility_orb",    // 恶意宝珠
            "minecraft:glass_bottle",       // 玻璃瓶
            "minecraft:glass_bottle",
            "minecraft:glass_bottle"
        ]
    ).id("kubejs:l2hostility/bottle_of_sanity_craft").stage("ON");

    // 诅咒之瓶  * 3
    e.shapeless(
        Item.of("l2hostility:bottle_of_curse", 3),
        [
            "l2complements:cursed_droplet", // 诅咒飞沫
            "minecraft:glass_bottle",
            "minecraft:glass_bottle",
            "minecraft:glass_bottle"
        ]
    ).id("kubejs:l2hostility/bottle_of_curse").stage("ON");

    // 理智之瓶 * 3
    e.shapeless(
        Item.of("l2hostility:bottle_of_sanity", 3),
        [
            "l2hostility:bottle_of_sanity", // 理智之瓶 (已有的)
            "l2complements:life_essence",   // 生命精华
            "minecraft:glass_bottle",
            "minecraft:glass_bottle",
            "minecraft:glass_bottle"
        ]
    ).id("kubejs:l2hostility/bottle_of_sanity_renew").stage("ON");

    // 混沌块 
    e.shaped(
        Item.of("l2hostility:chaos_block"),
        [
            "XXX",
            "XXX",
            "XXX"
        ],
        {
            X: "l2hostility:chaos_ingot" // 混沌锭
        }
    ).id("kubejs:l2hostility/chaos_block").stage("ON");

    // 混沌锭
    e.shaped(
        Item.of("l2hostility:chaos_ingot"),
        [
            "B4B",
            "1A2",
            "B3B"
        ],
        {
            "1": "l2complements:soul_flame",      // 灵魂烈焰
            "2": "l2complements:hard_ice",        // 硬冰
            "3": "l2complements:explosion_shard", // 爆炸碎片
            "4": "l2complements:captured_wind",   // 捕获之风
            A: "l2hostility:hostility_orb",     // 恶意宝珠
            B: "l2hostility:bottle_of_curse"    // 诅咒之瓶
        }
    ).id("kubejs:l2hostility/chaos_ingot_craft").stage("ON"); // 添加 _craft 以区别于解包配方

    // 混沌锭  * 9
    e.shapeless(
        Item.of("l2hostility:chaos_ingot", 9),
        [
            "l2hostility:chaos_block" // 混沌块
        ]
    ).id("kubejs:l2hostility/chaos_ingot_from_chaos_block").stage("ON");

    // 掠夺护符 I 
    e.shaped(
        Item.of("l2hostility:charm_of_looting_1"),
        [
            " A ",
            "DID",
            " A "
        ],
        {
            A: "minecraft:gold_ingot",   // 金锭
            D: "minecraft:copper_ingot", // 铜锭
            I: "minecraft:emerald"       // 绿宝石
        }
    ).id("kubejs:l2hostility/charm_of_looting_1").stage("ON");

    // 掠夺护符 III 
    e.shaped(
        Item.of("l2hostility:charm_of_looting_3"),
        [
            " A ",
            "DID",
            " A "
        ],
        {
            A: "l2complements:life_essence",  // 生命精华
            D: "l2hostility:witch_droplet", // 女巫飞沫
            I: "l2hostility:chaos_ingot"    // 混沌锭
        }
    ).id("kubejs:l2hostility/charm_of_looting_3").stage("ON");

    // 掠夺护符 II
    e.shaped(
        Item.of("l2hostility:charm_of_looting_2"),
        [
            " A ",
            "DID",
            " A "
        ],
        {
            A: "minecraft:blaze_powder",  // 烈焰粉
            D: "minecraft:dragon_breath", // 龙息
            I: "minecraft:diamond"        // 钻石
        }
    ).id("kubejs:l2hostility/charm_of_looting_2").stage("ON");

    // 嫉妒诅咒
    e.custom({
        type: "minecraft:crafting_shaped",
        category: "misc",
        key: {
            "1": {
                type: "l2library:enchantment", // 自定义配料类型
                enchantment: "minecraft:looting",
                min_level: 1
            },
            "2": {
                type: "l2library:enchantment",
                enchantment: "minecraft:silk_touch",
                min_level: 1
            },
            B: { item: "minecraft:prismarine_shard" }, // 海晶碎片
            C: { item: "minecraft:ender_eye" },        // 末影之眼
            I: { item: "l2hostility:chaos_ingot" }     // 混沌锭
        },
        pattern: [
            "B1B",
            "CIC",
            "B2B"
        ],
        result: { item: "l2hostility:curse_of_envy" }
    }).id("kubejs:l2hostility/curse_of_envy").stage("ON");

    // 神化之书
    e.custom({
        "type": "minecraft:crafting_shaped",
        "conditions": [
            {
                "type": "enigmaticaddons:is_enabled",
                "item": "enigmaticaddons:bless_amplifier"
            }
        ],
        "pattern": [
            "ABA",
            "CDC",
            "AEA"
        ],
        "key": {
            "A": {
                "item": "minecraft:glowstone_dust"
            },
            "B": {
                "item": "enigmaticaddons:ichor_droplet"
            },
            "C": {
                "item": "minecraft:quartz"
            },
            "D": {
                "item": "enigmaticlegacy:enchantment_transposer"
            },
            "E": {
                "item": "enigmaticaddons:pure_heart"
            }
        },
        "result": {
            "item": "enigmaticaddons:bless_amplifier"
        }
    }).id("kubejs:enigmaticaddons/bless_amplifier").stage("ON");

    // 暴食诅咒
    e.custom({
        type: "minecraft:crafting_shaped",
        category: "misc",
        key: {
            A: { type: "l2library:enchantment", enchantment: "minecraft:looting", min_level: 1 },
            E: { type: "l2library:enchantment", enchantment: "minecraft:vanishing_curse", min_level: 1 },
            B: { item: "minecraft:netherite_ingot" }, // 下界合金锭
            C: { item: "l2hostility:cursed" },        // 诅咒符文
            D: { item: "l2hostility:wither" },        // 凋零符文
            I: { item: "l2hostility:chaos_ingot" }     // 混沌锭
        },
        pattern: [
            "BAB",
            "CID",
            "BEB"
        ],
        result: { item: "l2hostility:curse_of_gluttony" }
    }).id("kubejs:l2hostility/curse_of_gluttony").stage("ON");

    // 混沌锭 
    e.blasting("l2hostility:chaos_ingot", Ingredient.of("#l2hostility:chaos_equipment")) // 输入：标签 l2hostility:chaos_equipment
        .xp(1.0)
        .cookingTime(200)
        .id("kubejs:l2hostility/chaos_ingot_recycle_blasting").stage("ON");


    // 掠夺护符 IV 
    e.shaped(
        Item.of("l2hostility:charm_of_looting_4"),
        [
            " A ",
            "DID",
            " A "
        ],
        {
            A: "l2complements:blackstone_core", // 黑石核心
            D: "l2complements:force_field",   // 力场（物品）
            I: "l2hostility:miracle_ingot"    // 奇迹锭
        }
    ).id("kubejs:l2hostility/charm_of_looting_4").stage("ON");

    // 贪婪诅咒
    e.custom({
        type: "minecraft:crafting_shaped",
        category: "misc",
        key: {
            A: { type: "l2library:enchantment", enchantment: "minecraft:looting", min_level: 1 },
            E: { type: "l2library:enchantment", enchantment: "minecraft:fortune", min_level: 1 },
            B: { item: "minecraft:gold_ingot" },   // 金锭
            C: { item: "l2hostility:speedy" },     // 急速符文
            D: { item: "l2hostility:tank" },       // 坦克符文
            I: { item: "l2hostility:chaos_ingot" }  // 混沌锭
        },
        pattern: [
            "BAB",
            "CID",
            "BEB"
        ],
        result: { item: "l2hostility:curse_of_greed" }
    }).id("kubejs:l2hostility/curse_of_greed").stage("ON");

    // 色欲诅咒
    e.custom({
        type: "minecraft:crafting_shaped",
        category: "misc",
        key: {
            A: { type: "l2library:enchantment", enchantment: "minecraft:looting", min_level: 1 },
            B: { type: "l2library:enchantment", enchantment: "minecraft:binding_curse", min_level: 1 },
            E: { item: "minecraft:phantom_membrane" }, // 幻翼膜
            C: { item: "l2hostility:regenerate" },     // 再生符文
            D: { item: "l2hostility:invisible" },      // 隐形符文
            I: { item: "l2hostility:chaos_ingot" }      // 混沌锭
        },
        pattern: [
            "BAB",
            "CID",
            "BEB"
        ],
        result: { item: "l2hostility:curse_of_lust" }
    }).id("kubejs:l2hostility/curse_of_lust").stage("ON");

    // 傲慢诅咒
    e.shaped(
        Item.of("l2hostility:curse_of_pride"),
        [
            "FAF",
            "DIE",
            "BCB"
        ],
        {
            A: "l2hostility:killer_aura",     // 杀戮光环符文
            C: "l2hostility:protection",      // 保护符文
            D: "l2hostility:dementor",        // 摄魂怪符文
            E: "l2hostility:adaptive",        // 适应符文
            F: "l2hostility:growth",          // 生长符文
            B: "l2hostility:hostility_essence",// 恶意精华
            I: "l2hostility:miracle_ingot"     // 奇迹锭
        }
    ).id("kubejs:l2hostility/curse_of_pride").stage("ON");

    // 懒惰诅咒
    e.custom({
        type: "minecraft:crafting_shaped",
        category: "misc",
        key: {
            E: { type: "l2library:enchantment", enchantment: "minecraft:vanishing_curse", min_level: 1 },
            A: { item: "l2complements:blackstone_core" }, // 黑石核心
            B: { item: "minecraft:copper_ingot" },      // 铜锭
            C: { item: "l2hostility:bottle_of_sanity" },// 理智之瓶
            I: { item: "l2hostility:chaos_ingot" }       // 混沌锭
        },
        pattern: [
            "BEB",
            "CIC",
            "BAB"
        ],
        result: { item: "l2hostility:curse_of_sloth" }
    }).id("kubejs:l2hostility/curse_of_sloth").stage("ON");

    // 暴怒诅咒
    e.shaped(
        Item.of("l2hostility:curse_of_wrath"),
        [
            "314",
            "5I6",
            "B2B"
        ],
        {
            "1": "l2hostility:fiery",           // 火焰符文
            "2": "l2hostility:reprint",         // 重印符文
            "3": "l2hostility:shulker",         // 潜影贝符文
            "4": "l2hostility:grenade",         // 手榴弹符文
            "5": "l2hostility:counter_strike",  // 反击符文
            "6": "l2hostility:reflect",         // 反射符文
            B: "l2hostility:hostility_essence",// 恶意精华
            I: "l2hostility:miracle_ingot"     // 奇迹锭
        }
    ).id("kubejs:l2hostility/curse_of_wrath").stage("ON");

    // 探测眼镜
    e.shaped(
        Item.of("l2hostility:detector_glasses"),
        [
            "ADA"
        ],
        {
            A: "minecraft:ender_eye",   // 末影之眼
            D: "minecraft:iron_ingot"   // 铁锭
        }
    ).id("kubejs:l2hostility/detector_glasses").stage("ON");

    // 神性之光
    e.shaped(
        Item.of("l2hostility:divinity_light"),
        [
            "STS",
            "TIT",
            "ETA"
        ],
        {
            A: "l2hostility:killer_aura",  // 杀戮光环符文
            E: "l2hostility:gravity",      // 重力符文
            I: "l2hostility:curse_of_sloth",// 懒惰诅咒
            S: "l2hostility:hostility_orb",// 恶意宝珠
            T: "l2hostility:miracle_ingot" // 奇迹锭
        }
    ).id("kubejs:l2hostility/divinity_light").stage("ON");

    // 永恒女巫充能
    e.shaped(
        Item.of("l2hostility:eternal_witch_charge"),
        [
            "ABA",
            "BCB",
            "DBD"
        ],
        {
            A: "minecraft:gunpowder",          // 火药
            B: "l2complements:blackstone_core",// 黑石核心
            C: "l2hostility:witch_droplet",    // 女巫飞沫
            D: "minecraft:blaze_powder"        // 烈焰粉
        }
    ).id("kubejs:l2hostility/eternal_witch_charge").stage("ON");

    // 火焰之刺 
    e.shaped(
        Item.of("l2hostility:flaming_thorn"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "l2hostility:drain",             // 吸取符文
            B: "l2complements:warden_bone_shard",// 监守者骨片
            D: "l2hostility:soul_burner",       // 灵魂燃烧符文
            I: "l2hostility:chaos_ingot"        // 混沌锭
        }
    ).id("kubejs:l2hostility/flaming_thorn").stage("ON");

    // 尼德霍格的贪婪
    e.shaped(
        Item.of("l2hostility:greed_of_nidhoggur"),
        [
            "AIA",
            "EOE",
            "BIB"
        ],
        {
            A: "l2hostility:ragnarok",         // 诸神黄昏符文
            B: "l2hostility:pulling",          // 拉扯符文
            E: "l2complements:eternium_ingot", // 永恒锭
            I: "l2hostility:miracle_ingot",    // 奇迹锭
            O: "l2hostility:curse_of_greed"    // 贪婪诅咒
        }
    ).id("kubejs:l2hostility/greed_of_nidhoggur").stage("ON");

    // 恶意信标
    e.shaped(
        Item.of("l2hostility:hostility_beacon"),
        [
            "E3E",
            "1B1",
            "C2C"
        ],
        {
            "1": "l2hostility:killer_aura",     // 杀戮光环符文
            "2": "l2hostility:gravity",         // 重力符文
            "3": "l2hostility:drain",           // 吸取符文
            B: "minecraft:beacon",            // 信标
            C: "minecraft:crying_obsidian",   // 哭泣的黑曜石
            E: "l2hostility:hostility_essence"// 恶意精华
        }
    ).id("kubejs:l2hostility/hostility_beacon").stage("ON");

    // 恶意探测器
    e.shaped(
        Item.of("l2hostility:hostility_detector"),
        [
            "ADA",
            "BCB",
            "ABA"
        ],
        {
            A: "minecraft:rotten_flesh",  // 腐肉
            B: "minecraft:bone",          // 骨头
            C: "minecraft:iron_ingot",    // 铁锭
            D: "minecraft:lightning_rod"  // 避雷针
        }
    ).id("kubejs:l2hostility/hostility_detector").stage("ON");

    // 神性十字
    e.shaped(
        Item.of("l2hostility:divinity_cross"),
        [
            "STS",
            "TIT",
            "ETA"
        ],
        {
            A: "l2hostility:killer_aura",    // 杀戮光环符文
            E: "l2hostility:drain",          // 吸取符文
            I: "l2hostility:miracle_ingot",  // 奇迹锭
            S: "l2hostility:witch_droplet",  // 女巫飞沫
            T: "l2complements:life_essence"  // 生命精华
        }
    ).id("kubejs:l2hostility/divinity_cross").stage("ON");

    // 恶意精华
    e.custom({
        type: "l2complements:burnt",
        chance: 512,
        ingredient: { item: "l2hostility:bottle_of_curse" }, // 诅咒之瓶
        result: { item: "l2hostility:hostility_essence" }
    }).id("kubejs:l2hostility/hostility_essence_from_burnt").stage("ON");

    // 九头蛇 Boss 生成器 (Hydra Boss Spawner) * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:hydra_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:soul_burner",    // 灵魂燃烧符文
                "2": "l2hostility:cursed",         // 诅咒符文
                A: "twilightforest:fiery_blood", // 九头蛇的烈焰之血
                I: "l2hostility:chaos_ingot",    // 混沌锭
                T: "twilightforest:hydra_trophy"   // 九头蛇战利品
            }
        ).id("kubejs:l2hostility/hydra_boss_spawner").stage("ON");
    }

    // 恶意刷怪笼
    e.shaped(
        Item.of("l2hostility:hostility_spawner"),
        [
            "ADA",
            "BCB",
            "ABA"
        ],
        {
            A: "minecraft:netherite_ingot",    // 下界合金锭
            B: "l2complements:explosion_shard",// 爆炸碎片
            C: "minecraft:nether_star",        // 下界之星
            D: "l2complements:cursed_droplet"  // 诅咒飞沫
        }
    ).id("kubejs:l2hostility/hostility_spawner").stage("ON");

    // 无限手套 
    e.shaped(
        Item.of("l2hostility:infinity_glove"),
        [
            "BAB",
            "III",
            "DID"
        ],
        {
            A: "l2hostility:split",    // 分裂符文
            B: "l2hostility:teleport", // 传送符文
            D: "l2hostility:pulling",  // 拉扯符文
            I: "l2hostility:chaos_ingot"// 混沌锭
        }
    ).id("kubejs:l2hostility/infinity_glove").stage("ON");

    // 幽灵骑士 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:knight_phantom_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:reflect",              // 反射符文
                "2": "l2hostility:cursed",               // 诅咒符文
                A: "twilightforest:knightmetal_ingot", // 骑士金属锭
                I: "l2hostility:chaos_ingot",          // 混沌锭
                T: "twilightforest:knight_phantom_trophy"// 幽灵骑士战利品
            }
        ).id("kubejs:l2hostility/knight_phantom_boss_spawner").stage("ON");
    }

    // 巫妖 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:lich_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:weakness",         // 虚弱符文
                "2": "l2hostility:cursed",           // 诅咒符文
                A: "minecraft:skeleton_skull",     // 骷髅头颅
                I: "l2hostility:chaos_ingot",      // 混沌锭
                T: "twilightforest:lich_trophy"      // 巫妖战利品
            }
        ).id("kubejs:l2hostility/lich_boss_spawner").stage("ON");
    }

    // 米诺菇 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:minoshroom_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:tank",             // 坦克符文
                "2": "l2hostility:cursed",           // 诅咒符文
                A: "twilightforest:raw_meef",      // 生米诺菇肉排 (Meef Steak)
                I: "l2hostility:chaos_ingot",      // 混沌锭
                T: "twilightforest:minoshroom_trophy"// 米诺菇战利品
            }
        ).id("kubejs:l2hostility/minoshroom_boss_spawner").stage("ON");
    }

    // 奇迹块
    e.shaped(
        Item.of("l2hostility:miracle_block"),
        [
            "XXX",
            "XXX",
            "XXX"
        ],
        {
            X: "l2hostility:miracle_ingot" // 奇迹锭
        }
    ).id("kubejs:l2hostility/miracle_block").stage("ON");

    // 奇迹锭 
    e.shaped(
        Item.of("l2hostility:miracle_ingot"),
        [
            "ABA",
            "ACA",
            "ABA"
        ],
        {
            A: "l2hostility:miracle_powder",  // 奇迹粉末
            B: "l2hostility:hostility_essence",// 恶意精华
            C: "l2hostility:chaos_ingot"      // 混沌锭
        }
    ).id("kubejs:l2hostility/miracle_ingot_craft").stage("ON");

    // 奇迹锭 * 9
    e.shapeless(
        Item.of("l2hostility:miracle_ingot", 9),
        [
            "l2hostility:miracle_block" // 奇迹块
        ]
    ).id("kubejs:l2hostility/miracle_ingot_from_miracle_block").stage("ON");

    // 娜迦 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:naga_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:speedy",           // 急速符文
                "2": "l2hostility:cursed",           // 诅咒符文
                A: "twilightforest:naga_scale",    // 娜迦鳞片
                I: "l2hostility:chaos_ingot",      // 混沌锭
                T: "twilightforest:naga_trophy"      // 娜迦战利品
            }
        ).id("kubejs:l2hostility/naga_boss_spawner").stage("ON");
    }

    // 异色瞳眼镜
    e.shaped(
        Item.of("l2hostility:oddeyes_glasses"),
        [
            " A ",
            "1I2"
        ],
        {
            "1": "minecraft:cyan_stained_glass_pane",    // 青色染色玻璃板
            "2": "minecraft:magenta_stained_glass_pane", // 品红色染色玻璃板
            A: "minecraft:gold_ingot",                 // 金锭
            I: "l2hostility:chaos_ingot"                 // 混沌锭
        }
    ).id("kubejs:l2hostility/oddeyes_glasses").stage("ON");

    // 白金之星 
    e.shaped(
        Item.of("l2hostility:platinum_star"),
        [
            "BIB",
            "ISI",
            "BIB"
        ],
        {
            B: "l2hostility:killer_aura",   // 杀戮光环符文
            I: "minecraft:nether_star",   // 下界之星
            S: "l2hostility:miracle_ingot"  // 奇迹锭
        }
    ).id("kubejs:l2hostility/platinum_star").stage("ON");

    // 复原口袋
    e.shaped(
        Item.of("l2hostility:pocket_of_restoration"),
        [
            "BLB",
            "SIS",
            "BGB"
        ],
        {
            B: "l2complements:blackstone_core", // 黑石核心
            G: "l2hostility:gravity",         // 重力符文
            I: "l2hostility:miracle_ingot",   // 奇迹锭
            L: "l2hostility:moonwalk",        // 月球漫步符文
            S: "l2hostility:dispell"          // 驱散符文
        }
    ).id("kubejs:l2hostility/pocket_of_restoration").stage("ON");

    // 腐蚀之戒 
    e.shaped(
        Item.of("l2hostility:ring_of_corrosion"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "l2hostility:corrosion",       // 腐蚀符文
            B: "l2complements:cursed_droplet",// 诅咒飞沫
            D: "l2hostility:erosion",         // 侵蚀符文
            I: "l2hostility:chaos_ingot"      // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_corrosion").stage("ON");

    // 神性之戒
    e.shaped(
        Item.of("l2hostility:ring_of_divinity"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "l2complements:life_essence",         // 生命精华
            B: "l2complements:totemic_gold_ingot", // 图腾金锭
            D: "l2hostility:dispell",              // 驱散符文
            I: "l2hostility:chaos_ingot"           // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_divinity").stage("ON");

    // 治疗之戒
    e.shaped(
        Item.of("l2hostility:ring_of_healing"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "minecraft:ghast_tear",             // 恶魂之泪
            B: "l2complements:totemic_gold_ingot", // 图腾金锭
            D: "l2hostility:regenerate",           // 再生符文
            I: "l2hostility:chaos_ingot"           // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_healing").stage("ON");

    // 奇迹粉末  - 回收
    e.blasting("l2hostility:miracle_powder", Ingredient.of("#l2hostility:trait_item")) // 输入：标签 l2hostility:trait_item
        .xp(1.0)
        .cookingTime(200)
        .id("kubejs:l2hostility/miracle_powder_recycle_blasting").stage("ON");

    // 禁锢之戒 
    e.shaped(
        Item.of("l2hostility:ring_of_incarceration"),
        [
            "BAB",
            "1I2",
            "BAB"
        ],
        {
            "1": "l2hostility:slowness",          // 缓慢符文
            "2": "l2hostility:freezing",          // 冰冻符文
            A: "l2hostility:killer_aura",       // 杀戮光环符文
            B: "l2complements:blackstone_core", // 黑石核心
            I: "l2hostility:chaos_ingot"        // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_incarceration").stage("ON");

    // 海洋之戒
    e.shaped(
        Item.of("l2hostility:ring_of_ocean"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "l2complements:guardian_eye",    // 守卫者之眼
            B: "l2complements:poseidite_ingot",// 波塞冬锭
            D: "l2hostility:nausea",          // 反胃符文
            I: "l2hostility:chaos_ingot"        // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_ocean").stage("ON");

    // 冰雪女王 Boss 生成器  * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:snow_queen_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:freezing",           // 冰冻符文
                "2": "l2hostility:cursed",             // 诅咒符文
                A: "twilightforest:ice_bomb",        // 冰炸弹
                I: "l2hostility:chaos_ingot",        // 混沌锭
                T: "twilightforest:snow_queen_trophy"  // 冰雪女王战利品
            }
        ).id("kubejs:l2hostility/snow_queen_boss_spawner").stage("ON");
    }

    // 生命之戒
    e.shaped(
        Item.of("l2hostility:ring_of_life"),
        [
            "BAB",
            "DID",
            "BAB"
        ],
        {
            A: "l2hostility:undying",            // 不死符文
            B: "l2complements:shulkerate_ingot", // 潜影锭
            D: "l2hostility:repelling",          // 排斥符文
            I: "l2hostility:chaos_ingot"         // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_life").stage("ON");

    // 反射之戒
    e.shaped(
        Item.of("l2hostility:ring_of_reflection"),
        [
            "1A2",
            "DID",
            "3A4"
        ],
        {
            "1": "l2hostility:poison",        // 中毒符文
            "2": "l2hostility:slowness",      // 缓慢符文
            "3": "l2hostility:nausea",        // 反胃符文
            "4": "l2hostility:blindness",     // 失明符文
            A: "l2complements:force_field", // 力场（物品）
            D: "l2hostility:reflect",       // 反射符文
            I: "l2hostility:chaos_ingot"    // 混沌锭
        }
    ).id("kubejs:l2hostility/ring_of_reflection_craft").stage("ON"); // _craft 以区别于可能的其他同名物品

    // 三条纹披风 
    e.shaped(
        Item.of("l2hostility:triple_strip_cape"),
        [
            " I ",
            "CCC",
            "FFF"
        ],
        {
            C: "#minecraft:banners",             // 标签：旗帜
            F: "l2complements:resonant_feather", // 共振羽毛
            I: "l2hostility:chaos_ingot"         // 混沌锭
        }
    ).id("kubejs:l2hostility/triple_strip_cape").stage("ON");

    // 恶魂主宰 Boss 生成器 * 4
    if (Platform.isLoaded("twilightforest")) {
        e.shaped(
            Item.of("twilightforest:ur_ghast_boss_spawner", 4),
            [
                "1I2",
                "ITI",
                "AIA"
            ],
            {
                "1": "l2hostility:wither",           // 凋零符文
                "2": "l2hostility:cursed",           // 诅咒符文
                A: "twilightforest:fiery_tears",   // 恶魂主宰的烈焰之泪
                I: "l2hostility:chaos_ingot",      // 混沌锭
                T: "twilightforest:ur_ghast_trophy"  // 恶魂主宰战利品
            }
        ).id("kubejs:l2hostility/ur_ghast_boss_spawner").stage("ON");
    }

    // 女巫充能
    e.shapeless(
        Item.of("l2hostility:witch_charge"),
        [
            "l2hostility:witch_droplet",    // 女巫飞沫
            "l2complements:cursed_droplet", // 诅咒飞沫
            "minecraft:gunpowder",          // 火药
            "minecraft:blaze_powder"        // 烈焰粉
        ]
    ).id("kubejs:l2hostility/witch_charge").stage("ON");

    // 女巫法杖
    e.shaped(
        Item.of("l2hostility:witch_wand"),
        [
            "123",
            "7I4",
            "S65"
        ],
        {
            "1": "l2hostility:poison",     // 中毒符文
            "2": "l2hostility:wither",     // 凋零符文
            "3": "l2hostility:slowness",   // 缓慢符文
            "4": "l2hostility:weakness",   // 虚弱符文
            "5": "l2hostility:levitation", // 悬浮符文
            "6": "l2hostility:freezing",   // 冰冻符文
            "7": "l2hostility:cursed",     // 诅咒符文
            I: "l2hostility:chaos_ingot",  // 混沌锭
            S: "minecraft:stick"           // 木棍
        }
    ).id("kubejs:l2hostility/witch_wand").stage("ON");

});